def getNumberEquivalent(string):
    """
        function to return the number equivalent value of string receive
    """
    values = {
        "zero": 0,
        "one": 1,
        "two": 2,
        "three": 3,
        "four": 4,
        "five": 5,
        "six": 6,
        "seven": 7,
        "eight": 8,
        "nine": 9,
        "ten": 10,
        "eleven": 11,
        "twelve": 12,
        "thirteen": 13,
        "fourteen": 14,
        "fifteen": 15,
        "sixteen": 16,
        "seventeen": 17,
        "eighteen": 18,
        "nineteen": 19,
        "twenty": 20,
        "thirty": 30,
        "forty": 40,
        "fifty": 50,
        "sixty": 60,
        "seventy": 70,
        "eighty": 80,
        "ninety": 90,
    }
    return values.get(string)


def getMultiplier(string):
    """
        Returns a number needed for multiplications during conversion
        getMultiplier("hundred") >>> 100
    """
    values = {
        "hundred": 100,
        "thousand": 1000,
        # "million": 1000000 # remove comment to support million
    }
    return values.get(string)


def evaluate(arr):
    """
        function to perform arithmetic on the List receive and return the sum
    """
    summation = 0
    for i in arr:
        if getMultiplier(i):
            summation *= getMultiplier(i)
        elif getNumberEquivalent(i):
            summation += getNumberEquivalent(i)
        else:
            raise ValueError(f"Incorrect word {i} encountered!!! ")
    return summation


def performConversion(numberStringList):
    # remove all cases of 'and' in the List to aid easy conversion
    while numberStringList.count('and'):
        numberStringList.remove('and')

    # create an empty List to manipulate the conversions
    millionList = thousandList = hundredList = []

    # Uncomment below code to to support million
    # Slice out the part of the word List that pertains to different aspect of the conversion like thousand,hundreds and unit

    # if(numberStringList.count('million')):
    #     millionList = numberStringList[:numberStringList.index('million')]
    #     numberStringList = numberStringList[numberStringList.index(
    #         'million')+1:]

    if(numberStringList.count('thousand')):
        thousandList = numberStringList[:numberStringList.index('thousand')]
        numberStringList = numberStringList[numberStringList.index(
            'thousand') + 1:]

    if(numberStringList.count('hundred')):
        hundredList = numberStringList[:numberStringList.index('hundred')]
        numberStringList = numberStringList[numberStringList.index(
            'hundred') + 1:]
    total = (evaluate(thousandList) * 1000) + \
        (evaluate(hundredList) * 100) + (evaluate(numberStringList))

    # + (evaluate(millionList) * 1000000)  #uncomment code to support million
    return total


print("PROGRAMME TO CONVERT A NUMBER GIVEN IN WORD TO FIGURE\n EYIBIO ELIJAH DONATUS\n 17/EG/EE/1325")

# Start a loop to keep the program running as long as the user wants to convert a number
while True:
    numberString = input("Enter number in words (q to quit): ")
    if numberString.upper() == 'Q':
        print('Goodbye see you later')
        break
    # convert string to lower case to ensure it matches words in dictionary if uppercase words are entered
    numberString = numberString.lower()

    # create an List from receive string
    numberStringList = numberString.split()

    total = performConversion(numberStringList)

    # print out the converted figure
    print(f'{numberString.capitalize()} = {total:,} in figures')]